/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.spark.JavaHBaseContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Tuple2;

@InterfaceAudience.Private
public final class JavaHBaseDistributedScan {
    private JavaHBaseDistributedScan() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("JavaHBaseDistributedScan {tableName}");
            return;
        }
        String tableName = args[0];
        SparkConf sparkConf = new SparkConf().setAppName("JavaHBaseDistributedScan " + tableName);
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        try {
            Configuration conf = HBaseConfiguration.create();
            JavaHBaseContext hbaseContext = new JavaHBaseContext(jsc, conf);
            Scan scan = new Scan();
            scan.setCaching(100);
            JavaRDD<Tuple2<ImmutableBytesWritable, Result>> javaRdd = hbaseContext.hbaseRDD(TableName.valueOf((String)tableName), scan);
            List results = javaRdd.map((Function)new ScanConvertFunction()).collect();
            System.out.println("Result Size: " + results.size());
        }
        finally {
            jsc.stop();
        }
    }

    private static class ScanConvertFunction
    implements Function<Tuple2<ImmutableBytesWritable, Result>, String> {
        private ScanConvertFunction() {
        }

        public String call(Tuple2<ImmutableBytesWritable, Result> v1) throws Exception {
            return Bytes.toString((byte[])((ImmutableBytesWritable)v1._1()).copyBytes());
        }
    }
}

