/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import org.apache.hadoop.hbase.spark.AndLogicExpression;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.EqualLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.IsNullLogicExpression;
import org.apache.hadoop.hbase.spark.LessThanLogicExpression;
import org.apache.hadoop.hbase.spark.LessThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.OrLogicExpression;
import org.apache.hadoop.hbase.spark.PassThroughLogicExpression;
import org.apache.hadoop.hbase.spark.datasources.BytesEncoder;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

@InterfaceAudience.Private
public final class DynamicLogicExpressionBuilder$ {
    public static DynamicLogicExpressionBuilder$ MODULE$;

    static {
        new DynamicLogicExpressionBuilder$();
    }

    public DynamicLogicExpression build(String expressionString, BytesEncoder encoder) {
        Tuple2<DynamicLogicExpression, Object> expressionAndOffset = this.build(new StringOps(Predef$.MODULE$.augmentString(expressionString)).split(' '), 0, encoder);
        return (DynamicLogicExpression)expressionAndOffset._1();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<DynamicLogicExpression, Object> build(String[] expressionArray, int offSet, BytesEncoder encoder) {
        Tuple2 tuple2;
        if (expressionArray[offSet].equals("(")) {
            Tuple2<DynamicLogicExpression, Object> left = this.build(expressionArray, offSet + 1, encoder);
            Tuple2<DynamicLogicExpression, Object> right = this.build(expressionArray, left._2$mcI$sp() + 1, encoder);
            if (expressionArray[left._2$mcI$sp()].equals("AND")) {
                tuple2 = new Tuple2((Object)new AndLogicExpression((DynamicLogicExpression)left._1(), (DynamicLogicExpression)right._1()), (Object)BoxesRunTime.boxToInteger((int)(right._2$mcI$sp() + 1)));
            } else {
                if (!expressionArray[left._2$mcI$sp()].equals("OR")) throw new Throwable(new StringBuilder(13).append("Unknown gate:").append(expressionArray[left._2$mcI$sp()]).toString());
                tuple2 = new Tuple2((Object)new OrLogicExpression((DynamicLogicExpression)left._1(), (DynamicLogicExpression)right._1()), (Object)BoxesRunTime.boxToInteger((int)(right._2$mcI$sp() + 1)));
            }
        } else {
            String command = expressionArray[offSet + 1];
            if (command.equals("<")) {
                tuple2 = new Tuple2((Object)new LessThanLogicExpression(expressionArray[offSet], new StringOps(Predef$.MODULE$.augmentString(expressionArray[offSet + 2])).toInt()), (Object)BoxesRunTime.boxToInteger((int)(offSet + 3)));
            } else if (command.equals("<=")) {
                tuple2 = new Tuple2((Object)new LessThanOrEqualLogicExpression(expressionArray[offSet], new StringOps(Predef$.MODULE$.augmentString(expressionArray[offSet + 2])).toInt()), (Object)BoxesRunTime.boxToInteger((int)(offSet + 3)));
            } else if (command.equals(">")) {
                tuple2 = new Tuple2((Object)new GreaterThanLogicExpression(expressionArray[offSet], new StringOps(Predef$.MODULE$.augmentString(expressionArray[offSet + 2])).toInt()), (Object)BoxesRunTime.boxToInteger((int)(offSet + 3)));
            } else if (command.equals(">=")) {
                tuple2 = new Tuple2((Object)new GreaterThanOrEqualLogicExpression(expressionArray[offSet], new StringOps(Predef$.MODULE$.augmentString(expressionArray[offSet + 2])).toInt()), (Object)BoxesRunTime.boxToInteger((int)(offSet + 3)));
            } else if (command.equals("==")) {
                tuple2 = new Tuple2((Object)new EqualLogicExpression(expressionArray[offSet], new StringOps(Predef$.MODULE$.augmentString(expressionArray[offSet + 2])).toInt(), false), (Object)BoxesRunTime.boxToInteger((int)(offSet + 3)));
            } else if (command.equals("!=")) {
                tuple2 = new Tuple2((Object)new EqualLogicExpression(expressionArray[offSet], new StringOps(Predef$.MODULE$.augmentString(expressionArray[offSet + 2])).toInt(), true), (Object)BoxesRunTime.boxToInteger((int)(offSet + 3)));
            } else if (command.equals("isNull")) {
                tuple2 = new Tuple2((Object)new IsNullLogicExpression(expressionArray[offSet], false), (Object)BoxesRunTime.boxToInteger((int)(offSet + 2)));
            } else if (command.equals("isNotNull")) {
                tuple2 = new Tuple2((Object)new IsNullLogicExpression(expressionArray[offSet], true), (Object)BoxesRunTime.boxToInteger((int)(offSet + 2)));
            } else {
                if (!command.equals("Pass")) throw new Throwable(new StringBuilder(22).append("Unknown logic command:").append(command).toString());
                tuple2 = new Tuple2((Object)new PassThroughLogicExpression(), (Object)BoxesRunTime.boxToInteger((int)(offSet + 3)));
            }
        }
        Tuple2 expr = tuple2;
        ((DynamicLogicExpression)expr._1()).setEncoder(encoder);
        return expr;
    }

    private DynamicLogicExpressionBuilder$() {
        MODULE$ = this;
    }
}

