package com.example.net.bjzhanghao.android.lazylistview;

import java.util.ArrayList;
import java.util.List;

import android.app.ListActivity;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class MainActivity extends ListActivity {

	List<MyRecord> exampleRecords;
	RemoteImageHelper lazyImageHelper = new RemoteImageHelper();

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		//Add some example records
		exampleRecords = new ArrayList<MyRecord>();
		exampleRecords.add(new MyRecord(0, "Mobile Phone 0",
				"http://img10.360buyimg.com/n2/g9/M03/03/10/rBEHaVA67HIIAAAAAAGfjv1prxgAAAr2wPYjK0AAZ-m072.jpg"));
		exampleRecords.add(new MyRecord(1, "Mobile Phone 1",
				"http://img11.360buyimg.com/n2/g5/M02/00/19/rBEIC0-_J5AIAAAAAAFXNd_SpUEAAAJ_wBRAXYAAVdN166.jpg"));
		exampleRecords.add(new MyRecord(2, "Mobile Phone 2",
				"http://img13.360buyimg.com/n2/g9/M03/00/10/rBEHalA0swQIAAAAAAHXHyx_4dUAAAGgQLkv04AAdc3943.jpg"));
		exampleRecords.add(new MyRecord(3, "Mobile Phone 3",
				"http://img12.360buyimg.com/n2/g7/M03/07/0D/rBEHZVBcFIgIAAAAAAGe2oQbuxMAABclQM87zkAAZ7y716.jpg"));
		exampleRecords.add(new MyRecord(4, "Mobile Phone 4",
				"http://img1.icson.com/product/pic160/21/013/21-013-007.jpg"));
		exampleRecords.add(new MyRecord(5, "Mobile Phone 5",
				"http://img2.icson.com/product/pic160/21/187/21-187-776.jpg"));
		exampleRecords.add(new MyRecord(6, "Mobile Phone 6",
				"http://img2.icson.com/product/pic200/21/136/21-136-902.jpg"));
		exampleRecords.add(new MyRecord(7, "Mobile Phone 7\n(Image not available)",
				"http://www.test.com/image/does/not/exist"));
		exampleRecords.add(new MyRecord(8, "Mobile Phone 8",
				"http://img2.icson.com/product/pic160/21/106/21-106-732.jpg"));
		exampleRecords.add(new MyRecord(9, "Mobile Phone 9",
				"http://img1.icson.com/product/pic200/21/587/21-587-157.jpg"));
		exampleRecords.add(new MyRecord(10, "Mobile Phone 10",
				"http://img2.icson.com/product/pic200/21/587/21-587-128.jpg"));

		setListAdapter(new MyAdapter(this));
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.activity_main, menu);
		return true;
	}

	class MyAdapter extends ArrayAdapter<MyRecord> {

		public MyAdapter(Context context) {
			super(context, R.layout.record_row, R.id.lblLabel, exampleRecords);
		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent) {
			View view = super.getView(position, convertView, parent);
			MyRecord record = getItem(position);

			TextView lblLabel = (TextView) view.findViewById(R.id.lblLabel);
			ImageView imageView = (ImageView) view.findViewById(R.id.img);

			lblLabel.setText(record.getLabel());

			//For demo purpose, cache is DISABLED here.
			lazyImageHelper.loadImage(imageView, record.getImageUrl(), false);

			//To enable cache, simply use following code:
			//lazyImageHelper.loadImage(imageView, record.getImageUrl(), true);

			return view;
		}
	}
}
