package com.acme;

import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

import java.io.File;
import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeCsvDemoTest {

    final static Logger logger = LoggerFactory.getLogger(MergeCsvDemoTest.class.getName());

    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @org.junit.Test
    public void mergeCsvFiles() throws IOException, UserException {

        File csvFolder = new File(getClass().getClassLoader().getResource("csv").getFile());
        File tempDir = tempFolder.newFolder("temp_dir");

        // Merge source files
        File[] srcFiles = csvFolder.listFiles();
        File destFile = new File(tempDir, "result.csv");

        long t0 = System.currentTimeMillis();
        new MergeCsvDemo().mergeCsvFiles(srcFiles, destFile);
        long cost = System.currentTimeMillis() - t0;
        logger.info("Merged {} files, destination file size {}, cost {} ms", srcFiles.length, destFile.length(), cost);

    }
}